/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.frame;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.websm.property.WPropertyEditor;
import com.ibm.websm.property.WPropertyReadText;
import java.util.Hashtable;

public class CSPStateText
extends WPropertyReadText {
    public static final int STATE_READY = 1;
    public static final int STATE_NO_POWER = 3;
    public static final int STATE_INITIALIZING = 6;
    public static final int STATE_ERROR = 12;
    public static final int STATE_RUNNING = 8;
    public static final int STATE_ERROR_DUMP_IN_PROCESS = 13;
    public static final int STATE_ERROR_TERMINATED = 14;
    public static final int STATE_CUOD_CTA = 15;
    public static final int STATE_COD_RECOVERY = 16;
    public static final int STATE_STANDBY = 17;
    public static final int STATE_POWEROFF_IN_PROCESS = 32;
    public static final int STATE_FSP_STATIC_FALLOVER_ERROR = 33;
    public static final int STATE_INCOMPATIBLE = 250;
    public static final int STATE_RECOVERY = 251;
    public static final int STATE_INCOMPLETE = 253;
    public static final int STATE_CONNECTIONLESS = 254;
    public static final int STATE_AUTH_DISCONNECTED = 240;
    public static final int STATE_AUTH_FAILED = 241;
    public static final int STATE_PW_UPDATES_REQD = 242;
    public static final int STATE_AUTH_CONNECTED = 243;
    public static final int STATE_NO_CONNECTION = 254;
    public static final int STATE_BOOTING = 5;
    public static final int STATE_OPEN_FIRMWARE = 9;
    private static String LPAR_BUNDLE = "LPARBundle";
    private static String PICOMMON_BUNDLE = "PIHSCCommonBundle";
    private static String CEC_BUNDLE = "CECBundle";
    private static Hashtable STATE_MAP = new Hashtable();

    public void updateValue(WPropertyEditor wPropertyEditor) {
        String string = wPropertyEditor.getAsText();
        String string2 = (String)STATE_MAP.get(string);
        if (string2 != null) {
            this.setText(string2);
        } else {
            this.setText("");
        }
    }

    public static String getStateValue(int n) {
        return (String)STATE_MAP.get(String.valueOf(n));
    }

    public static String getFrameTypeValue(int n) {
        String string = "";
        string = n == 0 ? "BPA_IH" : (n == 1 ? "BPA_H" : (n == 2 ? "PMU" : (n == 3 ? "BPA_IO_ONLY" : "Unknown")));
        return (String)STATE_MAP.get(string);
    }

    public static String getFrameStateValue(int n) {
        String string = "";
        string = n == 0 ? "Frame00" : (n == 1 ? "Frame01" : (n == 2 ? "Frame02" : (n == 3 ? "Frame03" : String.valueOf(n))));
        return (String)STATE_MAP.get(string);
    }

    public static boolean errorState(int n) {
        return n == 12;
    }

    public static boolean errorDumpState(int n) {
        return n == 13;
    }

    public static boolean readyState(int n) {
        return n == 1;
    }

    public static boolean runningState(int n) {
        return n == 8;
    }

    public static boolean initializingState(int n) {
        return n == 6;
    }

    public static boolean incompleteState(int n) {
        return n == 253;
    }

    public static boolean incompatibleState(int n) {
        return n == 250;
    }

    public static boolean noPowerState(int n) {
        return n == 3;
    }

    public static boolean noConnectionState(int n) {
        return n == 254;
    }

    public static boolean cuodCtaState(int n) {
        return n == 15;
    }

    public static boolean recoveryState(int n) {
        return n == 251;
    }

    public static boolean powerOffInProcessState(int n) {
        return n == 32;
    }

    public static boolean fspStaticFalloverErrorState(int n) {
        return n == 33;
    }

    public static boolean authFailedState(int n) {
        return n == 241;
    }

    public static boolean authPendingState(int n) {
        return n == 242;
    }

    public static boolean authDisconnectedState(int n) {
        return n == 240;
    }

    public static boolean authConnectedState(int n) {
        return n == 243;
    }

    static {
        STATE_MAP.put("1", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_READY", "Ready"));
        STATE_MAP.put("3", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_NO_POWER", "No Power"));
        STATE_MAP.put("6", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_INITIALIZING", "Initializing"));
        STATE_MAP.put("8", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_RUNNING", "Running"));
        STATE_MAP.put("12", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_ERROR", "Error"));
        STATE_MAP.put("13", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_ERROR_DUMP_IN_PROCESS", "Error - Dump in process"));
        STATE_MAP.put("14", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_ERROR_TERMINATED", "Error - Terminated"));
        STATE_MAP.put("15", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_CUOD_CTA", "CoD Click To Accept"));
        STATE_MAP.put("16", "On Demand Recovery");
        STATE_MAP.put("17", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_STANDBY", "Standby"));
        STATE_MAP.put("32", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_POWEROFF_IN_PROCESS", "Power Off in process"));
        STATE_MAP.put("33", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_FSP_STATIC_FALLOVER_ERROR", "SP static fallover error"));
        STATE_MAP.put("250", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_INCOMPATIBLE", "Version Mismatch"));
        STATE_MAP.put("251", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_STATE_RECOVERY", "Recovery"));
        STATE_MAP.put("253", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_INCOMPLETE", "Incomplete"));
        STATE_MAP.put("254", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_NO_CONNECTION", "No Connection"));
        STATE_MAP.put("240", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_AUTH_FAILED", "Authentication Disconnected"));
        STATE_MAP.put("241", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_AUTH_FAILED", "Failed Authentication"));
        STATE_MAP.put("242", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_AUTH_PENDING", "Pending Authentication - Password Updates Required"));
        STATE_MAP.put("243", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_AUTH_PENDING", "Authentication Connected"));
        STATE_MAP.put("Frame00", HSCResourceBundleUtil.getMessage("CECBundle", "FRAME_1BOOTING_1UNKNOWN", "Starting/Unknown"));
        STATE_MAP.put("Frame01", HSCResourceBundleUtil.getMessage("CECBundle", "FRAME_1STNDBY_1BOOTING", "Standby/Starting"));
        STATE_MAP.put("Frame03", HSCResourceBundleUtil.getMessage("CECBundle", "FRAME_BOTH_STNDBY", "Standby/Standby"));
        STATE_MAP.put("Frame02", HSCResourceBundleUtil.getMessage("CECBundle", "FRAME_1STNDBY_1NA", "Standby/Not Available"));
        STATE_MAP.put("BPA_H", "BPA (H System)");
        STATE_MAP.put("BPA_IH", "BPA (an IH)");
        STATE_MAP.put("BPA_PMU", "PMU - Hitach SRX");
        STATE_MAP.put("BPA_IO_ONLY", "BPA (IO-Only Frame)");
        STATE_MAP.put(String.valueOf(4096), HSCResourceBundleUtil.getMessage(PICOMMON_BUNDLE, "LPAR_STATE_NOT_ACTIVATED"));
        STATE_MAP.put(String.valueOf(4097), HSCResourceBundleUtil.getMessage(LPAR_BUNDLE, "LPAR_STATE_BOOTING"));
        STATE_MAP.put(String.valueOf(4098), HSCResourceBundleUtil.getMessage(LPAR_BUNDLE, "LPAR_STATE_RUNNING"));
        STATE_MAP.put(String.valueOf(4099), HSCResourceBundleUtil.getMessage(LPAR_BUNDLE, "PART_STOPPING"));
        STATE_MAP.put(String.valueOf(4100), HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "ERROR"));
        STATE_MAP.put(String.valueOf(4101), HSCResourceBundleUtil.getMessage(LPAR_BUNDLE, "PART_UNIT_ATTN"));
        STATE_MAP.put(String.valueOf(4102), HSCResourceBundleUtil.getMessage(LPAR_BUNDLE, "PART_DELETED"));
        STATE_MAP.put(String.valueOf(4103), HSCResourceBundleUtil.getMessage(LPAR_BUNDLE, "PART_TASK_DIED"));
        STATE_MAP.put(String.valueOf(4104), HSCResourceBundleUtil.getMessage(LPAR_BUNDLE, "LPAR_STATE_OPEN_FIRMWARE"));
        STATE_MAP.put(String.valueOf(4348), HSCResourceBundleUtil.getMessage(LPAR_BUNDLE, "NOT_AVAILABLE"));
        STATE_MAP.put(String.valueOf(8192), HSCResourceBundleUtil.getMessage(CEC_BUNDLE, "FRAME_1BOOTING_1UNKNOWN"));
        STATE_MAP.put(String.valueOf(8193), HSCResourceBundleUtil.getMessage(CEC_BUNDLE, "FRAME_1STNDBY_1BOOTING"));
        STATE_MAP.put(String.valueOf(8195), HSCResourceBundleUtil.getMessage(CEC_BUNDLE, "FRAME_BOTH_STNDBY"));
        STATE_MAP.put(String.valueOf(8194), HSCResourceBundleUtil.getMessage(CEC_BUNDLE, "FRAME_1STNDBY_1NA"));
        STATE_MAP.put(String.valueOf(8433), HSCResourceBundleUtil.getMessage("CECBundle", "CEC_AUTH_FAILED", "Failed Authentication"));
        STATE_MAP.put(String.valueOf(8434), HSCResourceBundleUtil.getMessage("CECBundle", "CEC_AUTH_PENDING", "Pending Authentication - Password Updates Required"));
        STATE_MAP.put(String.valueOf(8442), HSCResourceBundleUtil.getMessage("CECBundle", "CEC_INCOMPATIBLE", "Version Mismatch"));
        STATE_MAP.put(String.valueOf(8445), HSCResourceBundleUtil.getMessage("CECBundle", "CEC_INCOMPLETE", "Incomplete"));
        STATE_MAP.put(String.valueOf(8446), HSCResourceBundleUtil.getMessage("CECBundle", "CEC_NO_CONNECTION", "No Connection"));
    }
}

